#include "stdlib.h"
#include "cc2.h"

//--- defines -------------------------------------------------------



//--- Type defs -----------------------------------------------------



//--- Variables -----------------------------------------------------

static char const hexTable[]="0123456789ABCDEF";



//--- Functions -----------------------------------------------------

int abs( int val )
{
	if ( val > 0 )
	{
		return (val);
	}
	else
	{
		return (-val);
	}

} // labs


long labs( long val )
{
	if ( val > 0 )
	{
		return (val);
	}
	else
	{
		return (-val);
	}

} // labs


ULONG __udivdi3( ULONG num, ULONG den )
{
	int		shift;
	ULONG	quotient;

	if ( den > num ) return ( 0 );
	if ( num ==  0 ) return ( 0 );
	if ( den ==  0 ) return ( 0 );

	shift = 0;
	quotient = 0;
	do
	{
		den <<= 1;
		shift++;
	} while ( den <= num );

	do
	{
		den >>= 1;
		quotient <<= 1;
		if ( num >= den )
		{
			num -= den;
			quotient++;
		}
		shift--;
	} while ( shift != 0 );

	return ( quotient );
}


ULONG __umoddi3( ULONG num, ULONG den )
{
	int		shift;
	ULONG	quotient;

	if ( den > num ) return ( num );
	if ( num ==  0 ) return ( 0 );
	if ( den ==  0 ) return ( 0 );

	shift = 0;
	quotient = 0;
	do
	{
		den <<= 1;
		shift++;
	} while ( den <= num );
	
	do
	{
		den >>= 1;
		quotient <<= 1;
		if ( num >= den )
		{
			num -= den;
			quotient++;
		}
		shift--;
	} while ( shift != 0 );

	return ( num );
}


long __divdi3( long num, long den )
{
	int		sign;

	sign = ( num >> 31 ) ^ ( den >> 31 );
	num = labs( num );
	den = labs( den );

	if ( sign ) 
	{
		return ( -__udivdi3( num, den ) );
	}
	else 
	{
		return ( __udivdi3( num, den ) );
	}
}


long __moddi3( long num, long den )
{
	int sign;

	sign = ( num >> 31 ) ^ ( den >> 31 );
	num = labs( num );
	den = labs( den );

	if ( sign ) 
	{
		return ( -__umoddi3( num, den ) );
	}
	else 
	{
		return ( __umoddi3( num, den ) );
	}
}


static void Convert( ULONG value, char* dst, UINT base, bool sign )
{	
	char	buf[ 36 ];
	UINT	ii;

	if ( sign )				/* handle sign	*/
	{	
		*dst = '-';
		++dst;
	}
	if ( value == 0UL )		/* if 0, ready	*/
	{	
		dst[ 0 ] = '0';
		dst[ 1 ] = 0;
		return;
	}
	for ( ii = 0; value; ++ii )	/* convert to ascii, backward in buffer	*/
	{	
		buf[ ii ] = hexTable[ (UINT)( value % base ) ];
		value /= base;
	}
	for ( ; ii; )
	{	
		*dst = buf[ --ii ];	/* invert buffer	*/
		++dst;				/* next position	*/
	}
	*dst = 0;				/* end string		*/
} // Convert


char* ultoa( unsigned long value, char* dst, int base )
{
	Convert( value, dst, (UINT)base, FALSE );
	return dst;
} // ultoa


char* ltoa( long value, char* dst, int base )
{	
	bool sign;

	if ( (base == 10) && (value < 0) )	/* only base 10 may be negative!	*/
	{	
		sign = TRUE;
		value = -value;
	}
	else
	{
		sign = FALSE;
	}

	Convert( (ULONG)value, dst, (UINT)base, sign );
	return dst;
} // ltoa


char* itoa(int value, char* dst, int base)
{
	bool sign;

	if ( (base == 10) && (value < 0) )	/* only base 10 may be negative!	*/
	{
		sign = TRUE;
		value = -value;
	}
	else
	{
		sign = FALSE;
	}

	Convert( (ULONG)(UINT)value, dst, (UINT)base, sign );
	return dst;
} // itoa


char *strcat(char *dest, const char *src)
{
   char *r1 = dest - 1;

   while (*++r1);				/* FIND END OF STRING   */
   while (*r1++ = *src++);		/* APPEND SECOND STRING */
   return dest;
}

char *strchr(const char *string, int ch)
{
   char *str = (char *)string - 1;
   int   tch;

   for (;;)
     if      ( (tch = *++str) == ch ) return str;
     else if ( tch == 0 ) return NULL;
}

int strcmp(const char *string1, const char *string2)
{
   char *r1 = (char *)string1 - 1;
   char *r2 = (char *)string2 - 1;
   char cp;

   while ( (*++r2 == (cp = *++r1)) && cp );

   return *r1 - *r2;
}

char *strcpy(char *dest, const char *src)
{
   char *result = dest;

   while (*dest++ = *src++);
   return result;
}

size_t strlen(const char *string)
{
   const char *r1 = string - 1;
   while (*++r1);
   return r1 - string;
}

char *strrchr(const char *string, int c)
{
   char tch, ch;
   char *result;

   --string;
   ch     = c;
   result = (char *)0;

   for (;;)
   {
      if ((tch = *++string) == ch) result = (char*)string;
      if (tch == 0) break;
   }

   return result;
}



// --- End Of File --------------------------------------------------
