	.text
start:	


ClearBSS:					@ the obvious thing to do...
	@@ clear RAM area

	mov	dpp0,#pag:XBSSTAB	@ load dpp0 with pag:BSS table
	mov	r14,#dpp0:XBSSTAB	@ load r14 with pof:BSS table
	cmp	r14,#1				@ if pof == 1, no table is established
	jmp	cc_eq,InitROM		@ i.e. nothing to do for us here
	mov	r5,#zeros			@ load r5 with address of zero register
clearlp:
	mov	r2,[r14+]			@ load r2 with dpp1:offset of BSS area
	jmp	cc_eq,InitROM		@ a zero offset means "end of table"
	jnb	r14.14,0f			@ page boundary reached (table)?
	add	dpp0,#1				@ then dpp0++
	mov	r14,#0				@ and re-link r14 to dpp0
0:	mov	r6,[r14+]			@ load r6 with pag:BSS area
	mov	dpp1,r6				@ make dpp1 point to that page
	jnb	r14.14,0f			@ page boundary reached (table)?
	add	dpp0,#1				@ then dpp0++
	mov	r14,#0				@ and re-link r14 to dpp0
0:	mov	r7,[r14+]			@ load r7 with length of BSS area
	jnb	r14.14,0f			@ page boundary reached (table)?
	add	dpp0,#1				@ then dpp0++
	mov	r14,#0				@ and re-link r14 to dpp0
0:	mov	[r2+],[r5]			@ clear one word at a time
	cmpd2	r7,#2			@ end of current BSS area reached?
	jmpr	cc_ne,0b		@ not yet, so repeat this loop
	jmp	cc_uc,clearlp		@ otherwise clear next BSS area

InitROM:					@ initialize ROM sections
	@@ copy initialized variables from ROM to RAM

	mov	dpp0,#pag:XROMTAB	@ load dpp0 with pag:ROM table
	mov	r14,#dpp0:XROMTAB	@ load r14 with pof:ROM table
	cmp	r14,#1				@ if pof == 1, no table is established
	jmp	cc_eq,InitROM_end	@ i.e. the end has come for us
	mov	r0,#0xc0ff			@ load constant bitmask for page
initlp:
	mov r2,[r14+]			@ get segments of source and destiny
	jnb	r14.14,0f			@ page boundary reached (table)?
	add	dpp0,#1				@ then dpp0++
	mov	r14,#0				@ and re-link r14 to dpp0
0:	mov	r5,[r14+]			@ load r5 with sof:src
	jb	r5.0,InitROM_end	@ stop at the end (odd src address)
	jnb	r14.14,0f			@ page boundary reached (table)?
	add	dpp0,#1				@ then dpp0++
	mov	r14,#0				@ and re-link r14 to dpp0
0:	mov	r6,[r14+]			@ load r6 with sof:dst
	jnb	r14.14,0f			@ page boundary reached (table)?
	add	dpp0,#1				@ then dpp0++
	mov	r14,#0				@ and re-link r14 to dpp0
0:	mov	r7,[r14+]			@ load amount of bytes to copy
	jnb	r14.14,0f			@ page boundary reached (table)?
	add	dpp0,#1				@ then dpp0++
	mov	r14,#0				@ and re-link r14 to dpp0
0:	cmp	r7,#0				@ anything to copy?
	jmp	cc_eq,initlp		@ no, let s loop
	sub	r7,#2				@ cmpd2 wants it that way
	movb	rl3,rl2			@ seg:src
	movb	rh3,rh5			@ sof:src (only bits 15+14 needed)
	and	r3,r0				@ page coded as: ss00 0000 ssss ssss
	rol	r3,#2				@ 10bit page now correct
	mov	dpp1,r3				@ load dpp1 with pag:src
	bfldh	r5,#0xc0,#0x40	@ link r5 to dpp1 (src)
	movb	rl3,rh2			@ seg:dst
	movb	rh3,rh6			@ sof:dst (only bits 15+14 needed)
	and 	r3,r0			@ page coded as: dd00 0000 dddd dddd
	rol	r3,#2				@ 10bit page now correct
	mov	dpp2,r3				@ load dpp2 with pag:dst
	bfldh	r6,#0xc0,#0x80	@ link r6 to dpp2 (dst)
	nop						@ avoid cpu forwarding problem
copylp:		
	mov	[r6],[r5+]			@ copy one word
	add	r6,#2				@ dst++
	jnb	r6.14,0f			@ page boundary reached (dst)?
	add	dpp2,#1				@ then dpp2++
	mov	r6,#0x8000			@ and re-link r6 to dpp2
0:	jnb	r5.15,0f			@ page boundary reached (src)?
	add	dpp1,#1				@ then dpp1++
	mov	r5,#0x4000			@ and re-link r5 to dpp1
0:	cmpd2	r7,#0			@ everything copied?
	jmp	cc_ne,copylp		@ no, go on
	jmp	cc_uc,initlp		@ otherwise load next entry

InitROM_end:
	mov	dpp0,#__dpp0		@ initialize dpps (defined by gld166)
	mov	dpp1,#__dpp1
	mov	dpp2,#__dpp2
	mov	r0,#__ustktop		@ initialize user stack
	mov	r1,#0				@ default frame pointer

	@@  ready to call user's main() function

	calls	SEG:_main,SOF:_main

	.globl __exit
__exit:
	.globl _abort
_abort:
	pop r1					@ return to C2 program
	pop r1
	rets
