//--- defines -------------------------------------------------------

#define TRUE		(1==1)
#define FALSE		(0==1)
#define NULL		(0)


#define RTCH		(*(unsigned int volatile *)0xf0d6)
#define RTCL		(*(unsigned int volatile *)0xf0d4)


#define	SET_SDA		SET_SFRBIT( p3.9 )
#define	CLR_SDA		CLR_SFRBIT( p3.9 )
#define	SET_SCL		SET_SFRBIT( p3.8 )
#define	CLR_SCL		CLR_SFRBIT( p3.8 )


// Timerbase for plm.
#define	BASE_400	0
#define	BASE_800	1
#define	BASE_1600	2
#define	BASE_3200	3
#define	BASE_6400	4
#define	BASE_12800	5
#define	BASE_25600	6
#define	BASE_51200	7


// Tones to use with Beep().
#define	TONE_OFF   -1
#define	TONE_A     0
#define	TONE_AIS   1
#define	TONE_H     2
#define	TONE_C1    3
#define	TONE_CIS1  4
#define	TONE_D1    5
#define	TONE_DIS1  6
#define	TONE_E1    7
#define	TONE_F1    8
#define	TONE_FIS1  9
#define	TONE_G1    10
#define	TONE_GIS1  11
#define	TONE_A1    12  // 440 Hz concert pitch
#define	TONE_AIS1  13
#define	TONE_H1    14
#define	TONE_C2    15
#define	TONE_CIS2  16
#define	TONE_D2    17
#define	TONE_DIS2  18
#define	TONE_E2    19
#define	TONE_F2    20
#define	TONE_FIS2  21
#define	TONE_G2    22
#define	TONE_GIS2  23
#define	TONE_A2    24
#define	TONE_AIS2  25
#define	TONE_H2    26
#define	TONE_C3    27
#define	TONE_CIS3  28
#define	TONE_D3    29
#define	TONE_DIS3  30
#define	TONE_E3    31
#define	TONE_F3    32
#define	TONE_FIS3  33
#define	TONE_G3    34
#define	TONE_GIS3  35
#define	TONE_A3    36
#define	TONE_AIS3  37
#define	TONE_H3    38
#define	TONE_C4    39


// Bitrates for use with SerInit().
#define SPEED_300		0
#define SPEED_600		1
#define SPEED_1200		2
#define SPEED_2400		3
#define SPEED_4800		4
#define SPEED_9600		5
#define SPEED_19200		6
#define SPEED_38400		7
#define SPEED_57600		8
#define SPEED_115200	9


//--- Type defs -----------------------------------------------------

typedef unsigned long	ULONG;
typedef unsigned int	UINT;
typedef int				bool;
typedef int				size_t;


//--- Functions -----------------------------------------------------

extern	int		ReadAdc( int channel );
extern	void	InitPwm( int channel, int timebase, int length );
extern	void	SetPwm( int channel, int value );
extern	void	Sleep( int time );
extern	long	Timer( void );

extern	void	I2cStart( void );
extern	void	I2cStop( void );
extern	void	I2cSend( int byte );

extern	void	LcdClear( void );
extern	void	LcdGoto( int line, int pos );
extern	void	LcdPut( char * sz );

extern	void	SerInit( int speed );
extern	void	SerPut( char ch );
extern	void	SerSend( char * sz );


// --- End Of File --------------------------------------------------